# 導入必要的模組
import math
import NXOpen
import NXOpen.Assemblies  # 組件相關功能
import NXOpen.Assemblies.ProductInterface  # 產品介面功能
import NXOpen.PDM  # 產品數據管理功能
import NXOpen.Positioning  # 定位功能
import NXOpen.Preferences  # 偏好設定
import NXOpen.UF            # 底層 UF 函數
import pathlib  # 路徑處理

def main():
    # 取得目前檔案所在路徑
    filepath = str(pathlib.Path(__file__).resolve().parent)  # 使用 pathlib 獲取當前檔案路徑的父目錄

    # 取得 UF 工作階段物件，UF 是 NX 的底層框架，用於存取 NX 內部資料結構和函數
    theUfSession = NXOpen.UF.UFSession.GetUFSession()

    # 關閉所有開啟的零件，避免衝突
    theUfSession.Part.CloseAll() 

    # 取得 NX 開放式工作階段物件
    theSession = NXOpen.Session.GetSession()

    # ----------------------------------------------
    #   Menu: 檔案->新建...
    # ----------------------------------------------

    # 建立新的零件檔案物件
    fileNew1 = theSession.Parts.FileNew()

    # 設定模板檔案名稱
    fileNew1.TemplateFileName = "assembly-mm-template.prt"

    # 設定不使用空白模板
    fileNew1.UseBlankTemplate = False

    # 設定應用程式名稱為 "AssemblyTemplate"
    fileNew1.ApplicationName = "AssemblyTemplate"

    # 設定單位為毫米
    fileNew1.Units = NXOpen.Part.Units.Millimeters

    # 設定關係類型 (留空)
    fileNew1.RelationType = ""

    # 設定不使用主模型
    fileNew1.UsesMasterModel = "No"

    # 設定模板類型為項目
    fileNew1.TemplateType = NXOpen.FileNewTemplateType.Item

    # 設定模板顯示名稱為 "Assembly"
    fileNew1.TemplatePresentationName = "Assembly"

    # 設定項目類型 (留空)
    fileNew1.ItemType = ""

    # 設定專業化 (留空)
    fileNew1.Specialization = ""

    # 設定不允許建立替代表示
    fileNew1.SetCanCreateAltrep(False)

    # 設定新檔案名稱為 "assembly1.prt"
    fileNew1.NewFileName = "assembly1.prt" 

    # 設定主檔案名稱 (留空)
    fileNew1.MasterFileName = ""

    # 設定為顯示零件
    fileNew1.MakeDisplayedPart = True

    # 設定顯示零件選項為允許額外的
    fileNew1.DisplayPartOption = NXOpen.DisplayPartOption.AllowAdditional 

    # 提交新的零件檔案，建立組件
    nXObject1 = fileNew1.Commit()

    # 取得工作零件和顯示零件物件
    workPart = theSession.Parts.Work
    displayPart = theSession.Parts.Display

    # 銷毀 fileNew1 物件
    fileNew1.Destroy() 

    # 切換到建模應用程式
    theSession.ApplicationSwitchImmediate("UG_APP_MODELING") 

    # 建立一個添加元件建構器物件 
    addComponentBuilder1 = workPart.AssemblyManager.CreateAddComponentBuilder() 

    # 取得元件定位器物件
    componentPositioner1 = workPart.ComponentAssembly.Positioner 

    # 清除定位器網路
    componentPositioner1.ClearNetwork() 

    # 開始組裝約束
    componentPositioner1.BeginAssemblyConstraints() 

    # 取得允許零件間定位的偏好設定 (未使用)
    allowInterpartPositioning1 = theSession.Preferences.Assemblies.InterpartPositioning 

    # 建立定位網路 
    network1 = componentPositioner1.EstablishNetwork() 
    componentNetwork1 = network1 
    componentNetwork1.MoveObjectsState = True  # 允許移動物件 
    componentNetwork1.DisplayComponent = NXOpen.Assemblies.Component.Null 
    
    # ... (以下程式碼設定添加元件建構器的屬性，並添加元件 "ONE1") ...
    
    componentNetwork1.MoveObjectsState = True
    
    addComponentBuilder1.SetComponentAnchor(NXOpen.Assemblies.ProductInterface.InterfaceObject.Null)
    
    addComponentBuilder1.SetInitialLocationType(NXOpen.Assemblies.AddComponentBuilder.LocationType.Snap)
    
    addComponentBuilder1.SetCount(1)
    
    addComponentBuilder1.SetScatterOption(True)
    
    addComponentBuilder1.ReferenceSet = "Unknown"
    
    addComponentBuilder1.Layer = -1
    
    # ----------------------------------------------
    #   Dialog Begin Add Component
    # ----------------------------------------------
    basePart1, partLoadStatus1 = theSession.Parts.OpenBase(filepath + "\\one1.prt")
    
    partLoadStatus1.Dispose()
    addComponentBuilder1.ReferenceSet = "Use Model"
    
    addComponentBuilder1.Layer = -1
    
    partstouse1 = [NXOpen.BasePart.Null] * 1 
    part1 = basePart1
    partstouse1[0] = part1
    addComponentBuilder1.SetPartsToAdd(partstouse1)
    
    productinterfaceobjects1 = addComponentBuilder1.GetAllProductInterfaceObjects()
    
    arrangement1 = workPart.ComponentAssembly.Arrangements.FindObject("Arrangement 1")
    componentPositioner1.PrimaryArrangement = arrangement1
    
    # ----------------------------------------------
    #   Dialog Begin WCS Dynamics
    # ----------------------------------------------
    origin1 = NXOpen.Point3d(0.0, 0.0, 0.0)
    matrix1 = NXOpen.Matrix3x3()
    
    matrix1.Xx = 1.0
    matrix1.Xy = 0.0
    matrix1.Xz = 0.0
    matrix1.Yx = 0.0
    matrix1.Yy = 1.0
    matrix1.Yz = 0.0
    matrix1.Zx = 0.0
    matrix1.Zy = 0.0
    matrix1.Zz = 1.0
    workPart.WCS.SetOriginAndMatrix(origin1, matrix1)
    
    coordinates1 = NXOpen.Point3d(-26.442218893182485, -36.328535377957458, 1.1102230246251565e-16)
    point1 = workPart.Points.CreatePoint(coordinates1)
    
    coordinates2 = NXOpen.Point3d(-26.442218893182485, -36.328535377957458, 1.1102230246251565e-16)
    point2 = workPart.Points.CreatePoint(coordinates2)
    
    origin2 = NXOpen.Point3d(-26.442218893182485, -36.328535377957458, 1.1102230246251565e-16)
    vector1 = NXOpen.Vector3d(0.0, 0.0, 1.0)
    direction1 = workPart.Directions.CreateDirection(origin2, vector1, NXOpen.SmartObject.UpdateOption.WithinModeling)
    
    origin3 = NXOpen.Point3d(-26.442218893182485, -36.328535377957458, 1.1102230246251565e-16)
    vector2 = NXOpen.Vector3d(1.0, 0.0, 0.0)
    direction2 = workPart.Directions.CreateDirection(origin3, vector2, NXOpen.SmartObject.UpdateOption.WithinModeling)
    
    origin4 = NXOpen.Point3d(-26.442218893182485, -36.328535377957458, 1.1102230246251565e-16)
    matrix2 = NXOpen.Matrix3x3()
    
    matrix2.Xx = 1.0
    matrix2.Xy = 0.0
    matrix2.Xz = 0.0
    matrix2.Yx = 0.0
    matrix2.Yy = 1.0
    matrix2.Yz = 0.0
    matrix2.Zx = 0.0
    matrix2.Zy = 0.0
    matrix2.Zz = 1.0
    plane1 = workPart.Planes.CreateFixedTypePlane(origin4, matrix2, NXOpen.SmartObject.UpdateOption.WithinModeling)
    
    xform1 = workPart.Xforms.CreateXformByPlaneXDirPoint(plane1, direction2, point2, NXOpen.SmartObject.UpdateOption.WithinModeling, 0.625, False, False)
    
    cartesianCoordinateSystem1 = workPart.CoordinateSystems.CreateCoordinateSystem(xform1, NXOpen.SmartObject.UpdateOption.WithinModeling)
    
    point3 = NXOpen.Point3d(-26.442218893182485, -36.328535377957458, 1.1102230246251565e-16)
    orientation1 = NXOpen.Matrix3x3()
    
    orientation1.Xx = 1.0
    orientation1.Xy = 0.0
    orientation1.Xz = 0.0
    orientation1.Yx = 0.0
    orientation1.Yy = 1.0
    orientation1.Yz = 0.0
    orientation1.Zx = 0.0
    orientation1.Zy = 0.0
    orientation1.Zz = 1.0
    addComponentBuilder1.SetInitialLocationAndOrientation(point3, orientation1)

    componentNetwork1.Solve()
    
    componentPositioner1.ClearNetwork()
    
    nErrs1 = theSession.UpdateManager.AddToDeleteList(componentNetwork1)

    
    componentPositioner1.EndAssemblyConstraints()
    
    logicalobjects1 = addComponentBuilder1.GetLogicalObjectsHavingUnassignedRequiredAttributes()
    
    addComponentBuilder1.ComponentName = "ONE1"
    
    nXObject2 = addComponentBuilder1.Commit()
    
    errorList1 = addComponentBuilder1.GetOperationFailures()
    
    errorList1.Dispose()
    
    componentPositioner2 = workPart.ComponentAssembly.Positioner
    
    componentPositioner2.ClearNetwork()
    
    network2 = componentPositioner2.EstablishNetwork()
    
    componentNetwork2 = network2
    componentNetwork2.MoveObjectsState = True
    
    componentNetwork2.DisplayComponent = NXOpen.Assemblies.Component.Null
    
    componentNetwork2.NetworkArrangementsMode = NXOpen.Positioning.ComponentNetwork.ArrangementsMode.Existing
    
    constraint1 = componentPositioner2.CreateConstraint(True)
    
    componentConstraint1 = constraint1
    componentConstraint1.ConstraintType = NXOpen.Positioning.Constraint.Type.Fix
    
    component1 = nXObject2
    constraintReference1 = componentConstraint1.CreateConstraintReference(component1, component1, False, False, False)
    
    componentNetwork2.Solve()
    
    componentPositioner2.ClearNetwork()
    
    nErrs3 = theSession.UpdateManager.AddToDeleteList(componentNetwork2)
    
    addComponentBuilder1.Destroy()
    
    workPart.Points.DeletePoint(point1)
    
    componentPositioner2.PrimaryArrangement = NXOpen.Assemblies.Arrangement.Null
    
    addComponentBuilder2 = workPart.AssemblyManager.CreateAddComponentBuilder()
    
    componentPositioner3 = workPart.ComponentAssembly.Positioner
    
    componentPositioner3.ClearNetwork()
    
    componentPositioner3.PrimaryArrangement = arrangement1
    
    componentPositioner3.BeginAssemblyConstraints()
    
    allowInterpartPositioning2 = theSession.Preferences.Assemblies.InterpartPositioning
    
    network3 = componentPositioner3.EstablishNetwork()
    
    componentNetwork3 = network3
    componentNetwork3.MoveObjectsState = True
    
    componentNetwork3.DisplayComponent = NXOpen.Assemblies.Component.Null
    
    componentNetwork3.MoveObjectsState = True
    
    addComponentBuilder2.SetComponentAnchor(NXOpen.Assemblies.ProductInterface.InterfaceObject.Null)
    
    addComponentBuilder2.SetInitialLocationType(NXOpen.Assemblies.AddComponentBuilder.LocationType.Snap)
    
    addComponentBuilder2.SetCount(1)
    
    addComponentBuilder2.SetScatterOption(True)
    
    addComponentBuilder2.ReferenceSet = "Unknown"
    
    addComponentBuilder2.Layer = -1
    
    # ----------------------------------------------
    #   Dialog Begin Add Component
    # ----------------------------------------------
    basePart2, partLoadStatus2 = theSession.Parts.OpenBase(filepath + "\\three3.prt")
    
    partLoadStatus2.Dispose()
    addComponentBuilder2.ReferenceSet = "Use Model"
    
    addComponentBuilder2.Layer = -1
    
    partstouse2 = [NXOpen.BasePart.Null] * 1 
    part2 = basePart2
    partstouse2[0] = part2
    addComponentBuilder2.SetPartsToAdd(partstouse2)
    
    productinterfaceobjects2 = addComponentBuilder2.GetAllProductInterfaceObjects()
    
    coordinates3 = NXOpen.Point3d(-174.20044143746651, 82.750607830574893, 0.0)
    point4 = workPart.Points.CreatePoint(coordinates3)
    
    coordinates4 = NXOpen.Point3d(-174.20044143746651, 82.750607830574893, 0.0)
    point5 = workPart.Points.CreatePoint(coordinates4)
    
    origin5 = NXOpen.Point3d(-174.20044143746651, 82.750607830574893, 0.0)
    vector3 = NXOpen.Vector3d(0.0, 0.0, 1.0)
    direction3 = workPart.Directions.CreateDirection(origin5, vector3, NXOpen.SmartObject.UpdateOption.WithinModeling)
    
    origin6 = NXOpen.Point3d(-174.20044143746651, 82.750607830574893, 0.0)
    vector4 = NXOpen.Vector3d(1.0, 0.0, 0.0)
    direction4 = workPart.Directions.CreateDirection(origin6, vector4, NXOpen.SmartObject.UpdateOption.WithinModeling)
    
    origin7 = NXOpen.Point3d(-174.20044143746651, 82.750607830574893, 0.0)
    matrix3 = NXOpen.Matrix3x3()
    
    matrix3.Xx = 1.0
    matrix3.Xy = 0.0
    matrix3.Xz = 0.0
    matrix3.Yx = 0.0
    matrix3.Yy = 1.0
    matrix3.Yz = 0.0
    matrix3.Zx = 0.0
    matrix3.Zy = 0.0
    matrix3.Zz = 1.0
    plane2 = workPart.Planes.CreateFixedTypePlane(origin7, matrix3, NXOpen.SmartObject.UpdateOption.WithinModeling)
    
    xform2 = workPart.Xforms.CreateXformByPlaneXDirPoint(plane2, direction4, point5, NXOpen.SmartObject.UpdateOption.WithinModeling, 0.625, False, False)
    
    cartesianCoordinateSystem2 = workPart.CoordinateSystems.CreateCoordinateSystem(xform2, NXOpen.SmartObject.UpdateOption.WithinModeling)
    
    point6 = NXOpen.Point3d(-174.20044143746651, 82.750607830574893, 0.0)
    orientation2 = NXOpen.Matrix3x3()
    
    orientation2.Xx = 1.0
    orientation2.Xy = 0.0
    orientation2.Xz = 0.0
    orientation2.Yx = 0.0
    orientation2.Yy = 1.0
    orientation2.Yz = 0.0
    orientation2.Zx = 0.0
    orientation2.Zy = 0.0
    orientation2.Zz = 1.0
    addComponentBuilder2.SetInitialLocationAndOrientation(point6, orientation2)
    
    scaleAboutPoint1 = NXOpen.Point3d(-60.025321155956945, 50.627417338610151, 0.0)
    viewCenter1 = NXOpen.Point3d(60.025321155956945, -50.627417338610151, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(0.80000000000000004, scaleAboutPoint1, viewCenter1)
    
    scaleAboutPoint2 = NXOpen.Point3d(-75.031651444946135, 63.284271673262687, 0.0)
    viewCenter2 = NXOpen.Point3d(75.031651444946135, -63.284271673262687, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(0.80000000000000004, scaleAboutPoint2, viewCenter2)
    
    scaleAboutPoint3 = NXOpen.Point3d(-93.789564306182669, 79.105339591578357, 0.0)
    viewCenter3 = NXOpen.Point3d(93.789564306182669, -79.105339591578314, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(1.25, scaleAboutPoint3, viewCenter3)
    
    scaleAboutPoint4 = NXOpen.Point3d(-75.031651444946135, 63.284271673262722, 0.0)
    viewCenter4 = NXOpen.Point3d(75.031651444946135, -63.284271673262651, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(1.25, scaleAboutPoint4, viewCenter4)
    
    scaleAboutPoint5 = NXOpen.Point3d(-60.025321155956931, 50.627417338610165, 0.0)
    viewCenter5 = NXOpen.Point3d(60.025321155956981, -50.627417338610115, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(1.25, scaleAboutPoint5, viewCenter5)
    
    scaleAboutPoint6 = NXOpen.Point3d(-47.777730374640456, 40.259407320763046, 0.0)
    viewCenter6 = NXOpen.Point3d(47.777730374640491, -40.259407320763003, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(1.25, scaleAboutPoint6, viewCenter6)
    
    scaleAboutPoint7 = NXOpen.Point3d(-38.222184299712332, 32.207525856610438, 0.0)
    viewCenter7 = NXOpen.Point3d(38.222184299712431, -32.207525856610403, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(1.25, scaleAboutPoint7, viewCenter7)
    
    scaleAboutPoint8 = NXOpen.Point3d(-30.577747439769851, 25.76602068528835, 0.0)
    viewCenter8 = NXOpen.Point3d(30.577747439769983, -25.766020685288307, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(1.25, scaleAboutPoint8, viewCenter8)
    
    scaleAboutPoint9 = NXOpen.Point3d(-24.462197951815863, 20.612816548230693, 0.0)
    viewCenter9 = NXOpen.Point3d(24.462197951815991, -20.612816548230651, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(1.25, scaleAboutPoint9, viewCenter9)
    
    scaleAboutPoint10 = NXOpen.Point3d(-19.569758361452667, 16.490253238584565, 0.0)
    viewCenter10 = NXOpen.Point3d(19.569758361452795, -16.490253238584522, 0.0)
    workPart.ModelingViews.WorkView.ZoomAboutPoint(1.25, scaleAboutPoint10, viewCenter10)
    
    component2 = workPart.ComponentAssembly.RootComponent.FindObject("COMPONENT three3 1")
    face1 = component2.FindObject("PROTO#.Features|EXTRUDE(4)|FACE 170 {(4.5,1.4,-3) EXTRUDE(2)}")
    line1 = workPart.Lines.CreateFaceAxis(face1, NXOpen.SmartObject.UpdateOption.AfterModeling)
    
    objects1 = [NXOpen.TaggedObject.Null] * 1 
    objects1[0] = line1
    nErrs5 = theSession.UpdateManager.AddObjectsToDeleteList(objects1)
    
    constraint2 = componentPositioner3.CreateConstraint(True)
    
    componentConstraint2 = constraint2
    componentConstraint2.ConstraintType = NXOpen.Positioning.Constraint.Type.Concentric
    
    edge1 = component2.FindObject("PROTO#.Features|EXTRUDE(4)|EDGE * 170 EXTRUDE(2) 150 {(4.2990381056767,0,-2.25)(3,0,-4.5)(1.7009618943233,0,-2.25) EXTRUDE(2)}")
    constraintReference2 = componentConstraint2.CreateConstraintReference(component2, edge1, False, False, False)
    
    helpPoint1 = NXOpen.Point3d(-172.68940648487001, 82.750607830574893, -3.181612465460772)
    constraintReference2.HelpPoint = helpPoint1
    
    edge2 = component1.FindObject("PROTO#.Features|EXTRUDE(10)|EDGE * 140 EXTRUDE(12) 140 {(-4.5,5.7009618943233,20.25)(-4.5,7,22.5)(-4.5,8.2990381056767,20.25) EXTRUDE(8)}")
    constraintReference3 = componentConstraint2.CreateConstraintReference(component1, edge2, False, False, False)
    
    helpPoint2 = NXOpen.Point3d(-30.942218893182488, -30.82721954663829, 21.062815305025588)
    constraintReference3.HelpPoint = helpPoint2
    
    constraintReference3.SetFixHint(True)
    
    componentNetwork3.Solve()
    
    componentConstraint2.FlipAlignment()
    
    componentNetwork3.Solve()
    
    componentNetwork3.Solve()
    
    componentPositioner3.ClearNetwork()
    
    nErrs6 = theSession.UpdateManager.AddToDeleteList(componentNetwork3)
    
    componentPositioner3.EndAssemblyConstraints()
    
    logicalobjects2 = addComponentBuilder2.GetLogicalObjectsHavingUnassignedRequiredAttributes()
    
    addComponentBuilder2.ComponentName = "THREE3"
    
    nXObject3 = addComponentBuilder2.Commit()
    
    errorList2 = addComponentBuilder2.GetOperationFailures()
    
    errorList2.Dispose()

    # 刪除撤銷標記
    addComponentBuilder2.Destroy()
    workPart.Points.DeletePoint(point4)
    componentPositioner3.PrimaryArrangement = NXOpen.Assemblies.Arrangement.Null


    # 建立第三個添加元件建構器
    addComponentBuilder3 = workPart.AssemblyManager.CreateAddComponentBuilder()

    # 取得元件定位器物件
    componentPositioner4 = workPart.ComponentAssembly.Positioner

    # 清除定位器網路
    componentPositioner4.ClearNetwork()

    # 設定定位器的主要裝配物件
    componentPositioner4.PrimaryArrangement = arrangement1

    # 開始組裝約束
    componentPositioner4.BeginAssemblyConstraints()

    # 取得允許零件間定位的偏好設定 (未使用)
    allowInterpartPositioning3 = theSession.Preferences.Assemblies.InterpartPositioning

    # ... (建立表達式，類似於前述程式碼) ... 

    # 建立定位網路
    network4 = componentPositioner4.EstablishNetwork()
    componentNetwork4 = network4
    componentNetwork4.MoveObjectsState = True
    componentNetwork4.DisplayComponent = NXOpen.Assemblies.Component.Null

    # 允許移動物件
    componentNetwork4.MoveObjectsState = True

    # 設定添加元件建構器的屬性
    addComponentBuilder3.SetComponentAnchor(NXOpen.Assemblies.ProductInterface.InterfaceObject.Null)
    addComponentBuilder3.SetInitialLocationType(NXOpen.Assemblies.AddComponentBuilder.LocationType.Snap)
    addComponentBuilder3.SetCount(1)
    addComponentBuilder3.SetScatterOption(True)
    addComponentBuilder3.ReferenceSet = "Unknown"
    addComponentBuilder3.Layer = -1

    # ----------------------------------------------
    #   Dialog Begin Add Component
    # ----------------------------------------------

    # 清除定位器網路
    componentPositioner4.ClearNetwork()

    # 移除已添加的元件
    addComponentBuilder3.RemoveAddedComponents()

    # 銷毀添加元件建構器
    addComponentBuilder3.Destroy()

    # 設定定位器的主要裝配物件為空
    componentPositioner4.PrimaryArrangement = NXOpen.Assemblies.Arrangement.Null

    # 結束組裝約束
    componentPositioner4.EndAssemblyConstraints()

if __name__ == '__main__':
    main()