/******************************************************************************
             Copyright (c) 2006 Unigraphics Solutions, Inc.
                       Unpublished - All Rights Reserved

*******************************************************************************/
/*
The following example is implemented in two parts.  An external
NX Open API program loads a shared library that is built as an
internal NX Open API program.  Both programs may be compiled
and linked using ufcomp and uflink.

The shared library code is given first.  Compile and link it as an
internal NX Open API program named example_shlib.  This source
is uf_eg5a.c.

The following items apply to the internal NX Open API program:

The internal program does not require a conventional ufusr entry point.

The external program calls UF_initialize() and UF_terminate. It is
the external program that loads and executes the internal shared
library. The internal program should not call UF_initialize and
UF_terminate since the external program calls these functions.
Your internal program may not contain calls to functions that are
internal and interactive when the shared library executes in the
context of an external NX Open API program. This is because
internal only routines are not available to external NX Open API
programs.

The contents of ufd_load.h is as follows:
int ep_a(int argc, char *argv[]);
int ep_b(int argc, char *argv[]);
*/

#include <stdio.h>
#include <ufd_load.h>
 /*****************************************************************
  *
  * A sample shared library to be loaded using UF_load_library.
  * If three or more arguments are passed, the first, second, and
  * third arguments should be the name of the library loaded, the
  * name of the function called, and a printf format string (taking
  * two string arguments) respectively.
  *
  * Example:
  *
  *     Given:
  *
  *         argc = 3;
  *
  *         argv[0] = "shlib_a"
  *         argv[1] = "ep_a"
  *         argv[2] = "Call to %s() in library %s succeeded."
  *
  *     ep_a( argc, argv );     yields:
  *
  *         Call to ep_a() in library shlib_a succeeded.
  *
  *         3 arguments passed.
  *
  *         argv[0] = "shlib_a"
  *         argv[1] = "ep_a"
  *         argv[2] = "Call to %s() in library %s succeeded."
  *
  *
  ***/
extern int ep_a(
    int   argc,
    char *argv[] )
{
    int indx;
    if( 3 <= argc )
        printf( argv[2], argv[1], argv[0] );
    printf( "\n\n%d arguments passed.\n\n", argc );
     /* Show each argument. */
    for( indx = 0; indx < argc; indx++ )
    {
        printf( "argv[%d] = \"%s\"\n", indx, argv[indx] );
    }
    printf( "\n" );
    return( 0 );
}
 /*****************************************************************
  *
  * This second entry point illustrates access to
  * multiple entry points in the same shared library using
  * UF_load_library. Each entry point must be looked up
  * individually with separate calls to UF_load_library; but,
  * the library is only loaded once (on locating the first entry
  * point).
  *
  ***/
extern int ep_b(
    int   argc,
    char *argv[] )
{
     /* Borrow ep_a to keep example terse. */
    return( ep_a( argc, argv ) );
}
