/*
   Sample routine which sets up a callback.
*/
#include <stdio.h>
#include <string.h>
#include <uf.h>
#include <uf_ui.h>

#define UF_CALL(X) (report_error( __FILE__, __LINE__, #X, (X)))
#define ECHO(X)   (printf("\t%s = %d\n", #X, X))

static int report_error( char *file, int line, char *call, int irc)
{
    if (irc)
    {
        char
            err[133],
            messg[300];

        UF_get_fail_message(irc, err);
        sprintf(messg, "\n%s\nerror %d at line %d in %s\n%s",
            err, irc, line, file, call);
        printf("%s\n", messg);
        if (strlen(messg) > 300)
            printf("Error is too long - memory overwrite occurred!\n");
        strcpy(&messg[129], "...");
        uc1601(messg, TRUE);  /* Internal only - remove for external */
    }
    return(irc);
}

static void my_open_callback(UF_callback_reason_e_t reason,
    const void *application_data, void *user_data)
{
    const tag_p_t
        part = (tag_p_t)application_data;
    char
        part_name[MAX_FSPEC_SIZE+1];

    /* Note that this function needs to call UF_initialize()
       This requirement was added in V16.
    */
    if (UF_CALL(UF_initialize())) return;
    UF_PART_ask_part_name(*part, part_name);
    uc1601(part_name, TRUE);
    UF_terminate();
}


static UF_registered_fn_p_t function_id;

void ufusr(char *param, int *retcode, int paramLen)
{
    if (UF_CALL(UF_initialize())) return;

    if (!UF_CALL(UF_add_callback_function(UF_open_part_reason,
        my_open_callback, NULL, &function_id)))
        uc1601("Added callback", TRUE);

    UF_terminate();
}

int ufusr_ask_unload(void)
{
    return (UF_UNLOAD_SEL_DIALOG);
}

void ufusr_cleanup(void)
{

    if (!UF_CALL(UF_remove_callback_function(function_id)))
        uc1601("Removed callback", TRUE);
}
